% This script plots the single cell correlation between cell size and ABP
load('Figure3F_Data.mat');
chABP=1; chDAPI=2; chSE=3; chGem=4;

idxDMSO=ResultTable.Condition=="DMSO";
idxBort=ResultTable.Condition=="Bort";

%% normalize by mean of control
ResultTable.CInt(:,chSE) = ResultTable.CInt(:,chSE)/median(ResultTable.CInt(idxDMSO,chSE));
ResultTable.CInt(:,chABP) = ResultTable.CInt(:,chABP)/median(ResultTable.CInt(idxDMSO,chABP));

%% plot size vs. ABP
figure;
scatter(ResultTable.CInt(idxDMSO,chSE),ResultTable.CInt(idxDMSO,chABP),2,[0 .5 .7],'filled','MarkerFaceAlpha',.1); hold on
scatter(ResultTable.CInt(idxBort,chSE),ResultTable.CInt(idxBort,chABP),2,[1 1 1]*.4,'filled','MarkerFaceAlpha',.1); hold on
fd=fitlm(ResultTable.CInt(idxDMSO,chSE),ResultTable.CInt(idxDMSO,chABP));
plot([0.1; 3.5],fd.predict([0.1; 3.5]),'color',0.5*([0 83 125]./255),'linewidth',.5,'linestyle','-')
fb=fitlm(ResultTable.CInt(idxBort,chSE),ResultTable.CInt(idxBort,chABP));
plot([0.1; 3.5],fb.predict([0.1; 3.5]),'color',[0 0 0],'linewidth',.5,'linestyle','-')
axis equal; axis([0 3.5 -0.3 4]); xlabel('Cell Size (a.u.)'); ylabel('Active Proteasomes (a.u.)');
set(gca,'fontsize',14); 

figure; histogram(ResultTable.CInt(idxDMSO,chSE), 0:0.07:3.5, 'Normalization','pdf','FaceColor',[0 .5 .7]); hold on
histogram(ResultTable.CInt(idxBort,chSE), 0:0.07:3.5, 'Normalization','pdf','FaceColor',[1 1 1]*.4)
xlim([0 3.5]); box off; xticks(0:3)

figure; histogram(ResultTable.CInt(idxDMSO,chABP), -0.3:0.1:4, 'Normalization','pdf','FaceColor',[0 .5 .7]); hold on
histogram(ResultTable.CInt(idxBort,chABP), -0.3:0.1:4, 'Normalization','pdf','FaceColor',[1 1 1]*.4)
xlim([-.3 4]); box off; yticks([0 2 4]); xticks(0:4);

